TITLE						           	      { exa031a.pde }
   'Liquid Rotating as a Disk, Curl'
SELECT
   spectral_colors
DEFINITIONS                                     		
   r1=1.0     r2=0.3     r0=0.2					
   omega=1.0      						{ Angular velocity }
   vx=-omega*y     vy=omega*x               		{ Velocity components}
   v=vector( vx, vy)					{ Velocity vector }
   vm=sqrt(vx^2+vy^2)                                   	{ Magnitude of v }
   div_v=dx(vx)+ dy(vy)     curl_z=dx(vy)- dy(vx)
BOUNDARIES
region 'domain'
   start(r1,0)  arc to (0,r1) to (-r1,0) to (0,-r1) close 	
feature
   start 'inner' (r0+r2, 0) arc( center=r0,0) angle=360
PLOTS
   elevation( tangential( v)/(pi*r2^2) ) on 'inner'  	{ ? Curl_z }
   contour( vm/(pi*r1^2))					{ ? Average }
END

